#ifdef GL_ES
precision mediump float;
#endif

const float TWO_PI = 6.28318530718;

// output from the vertex shader (fragment color and texture coordinates)
varying vec4 v_fragmentColor;
varying vec2 v_texCoord;


// uniform variables provided by the application
// uniform sampler2D CC_Texture0;
uniform float u_progress;
uniform float u_power;
uniform float u_fade_start;
uniform vec4 u_bounds;

float my_noise(float x, float y) {
	float value = u_progress * TWO_PI;

	return cos((x - value) +(y - value)) +
			sin((x * 0.1223 + value) - (y * 1.623 + value)) * 0.5;
}

float progress(float x, float min, float max) {
	return (x - min) / (max - min);
}

const int LINE_COUNT = 3;

float getLineValue(int index, vec2 uv, float progress){
	uv.y += sin((uv.x + progress + float(index) * 1.7076) * TWO_PI) * 0.3 * uv.x;

	float distance_to_mid = abs(uv.y - 0.5) * 2.0;
	float mid_factor = pow((1.0 - distance_to_mid), 1.0 + uv.x * 3.0);

	return mid_factor;
}

// main shader function
void main() {
	//vec4 texel = texture2D(CC_Texture0, v_texCoord);
	vec2 bounds_origin = u_bounds.xy;
	vec2 bounds_size = u_bounds.zw;
	vec2 uv = (gl_FragCoord.xy - bounds_origin.xy) / bounds_size.xy;
	/*
	uv.y += sin((uv.x + u_progress) * TWO_PI) * 0.1 * uv.x;

	float distance_to_mid = abs(uv.y - 0.5) * 2.0;
	float mid_factor = pow((1.0 - distance_to_mid), 1.4);
	*/
	const float distance_to_progress = 0.2;
	float distance_value_start = (1.0 - smoothstep(0.0, distance_to_progress, abs(uv.x - (u_progress - 1.0))));
	float distance_value_end = (1.0 - smoothstep(0.0, distance_to_progress, abs(uv.x - (u_progress + 1.0))));
	float distance_value_mid = (1.0 - smoothstep(0.0, distance_to_progress, abs(uv.x - u_progress)));

	float progress_factor = max(distance_value_mid, max(distance_value_start, distance_value_end));

	vec4 color = v_fragmentColor;
	float value = 0.0;
	for(int i = 0; i < LINE_COUNT; i++) {
		value += getLineValue(i, uv, u_progress) / float(LINE_COUNT);
	}
	/*
	color = color + my_noise(gl_FragCoord.x * 0.012,
								  gl_FragCoord.y * -0.03 * (50.0 / bounds_size.x)
						 ) * u_power;
						 */
	//color = mix(color, color * 2.0, value);
	color = color * 3.0 * value;

	float prog = progress(uv.x, u_fade_start, 1.0);
	color = mix(color, vec4(0.0), pow(prog, 3.0));
	color = mix(color, color * 2.0, progress_factor);
	//color = mix(vec4(0.0), color, mid_factor);
	gl_FragColor = color;
}
